#include "USART.H"
struct WIFI wifi;
struct GPS  gps;
void USART1_Config(u32 bound)
{
RCC_APB2PeriphClockCmd(RCC_APB2Periph_USART1|RCC_APB2Periph_GPIOA, ENABLE);	
  
    GPIO_InitTypeDef GPIO_InitStructure;
    USART_InitTypeDef USART_InitStructure;
    NVIC_InitTypeDef NVIC_InitStructure; 


    RCC_APB2PeriphClockCmd(RCC_APB2Periph_USART1|RCC_APB2Periph_GPIOA,ENABLE);
 

    //USART1_TX   GPIOA.9
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_9;         
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;  
    GPIO_Init(GPIOA,&GPIO_InitStructure);            

    //USART1_RX      GPIOA.10ʼ
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_10;               
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;    
    GPIO_Init(GPIOA,&GPIO_InitStructure);                    

    //Usart1 NVIC 
    NVIC_InitStructure.NVIC_IRQChannel = USART1_IRQn;
    NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 3 ;  
    NVIC_InitStructure.NVIC_IRQChannelSubPriority = 3;       
    NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;       
    NVIC_Init(&NVIC_InitStructure);         

    //USART ʼ
    USART_InitStructure.USART_BaudRate = bound;                   
    USART_InitStructure.USART_WordLength = USART_WordLength_8b;   
    USART_InitStructure.USART_StopBits = USART_StopBits_1;         
    USART_InitStructure.USART_Parity = USART_Parity_No;            
    USART_InitStructure.USART_HardwareFlowControl = USART_HardwareFlowControl_None;
    USART_InitStructure.USART_Mode = USART_Mode_Rx|USART_Mode_Tx;  
    USART_Init(USART1,&USART_InitStructure);        

    USART_ITConfig(USART1,USART_IT_RXNE,ENABLE);   
	USART_ITConfig(USART1,USART_IT_IDLE,ENABLE);   
		
    USART_Cmd(USART1,ENABLE);                     
}
//Debug 
void USART2_Config( u32 bound )
{
	/* GPIO˿ */
	GPIO_InitTypeDef	GPIO_InitStructure;
	USART_InitTypeDef	USART_InitStructure;
	NVIC_InitTypeDef	NVIC_InitStructure;

	RCC_APB2PeriphClockCmd(  RCC_APB2Periph_GPIOA, ENABLE ); 
	RCC_APB1PeriphClockCmd( RCC_APB1Periph_USART2, ENABLE );                         /* ʹUSART2GPIOAʱ */

	/* PA2 TXD2 */
	GPIO_InitStructure.GPIO_Pin	= GPIO_Pin_2;
	GPIO_InitStructure.GPIO_Speed	= GPIO_Speed_50MHz;
	GPIO_InitStructure.GPIO_Mode	= GPIO_Mode_AF_PP;
	GPIO_Init( GPIOA, &GPIO_InitStructure );

	/* PA3 RXD2 */
	GPIO_InitStructure.GPIO_Pin	= GPIO_Pin_3;
	GPIO_InitStructure.GPIO_Mode	= GPIO_Mode_IN_FLOATING;
	GPIO_Init( GPIOA, &GPIO_InitStructure );


	/* USART ʼ */
	USART_InitStructure.USART_BaudRate		= bound;                                /* ڲ */
	USART_InitStructure.USART_WordLength		= USART_WordLength_8b;                  /* ֳΪ8λݸʽ */
	USART_InitStructure.USART_StopBits		= USART_StopBits_1;                     /* һֹͣλ */
	USART_InitStructure.USART_Parity		= USART_Parity_No;                      /* żУλ */
	USART_InitStructure.USART_HardwareFlowControl	= USART_HardwareFlowControl_None;  /* Ӳ */
	USART_InitStructure.USART_Mode			= USART_Mode_Rx | USART_Mode_Tx;        /* շģʽ */
	USART_Init( USART2, &USART_InitStructure );                                             /* ʼ1 */
	
	USART_Cmd( USART2, ENABLE );                                                            /* ʹܴ 2 */

}

uint8_t arry[256] = {0};
uint8_t arry_length;
void USART1_IRQHandler(void)  
{  
	// жϵʱռݰ
	uint8_t recContent;
	
    if(USART_GetITStatus(USART1, USART_IT_RXNE) != RESET)
    {
       USART_ClearITPendingBit(USART1, USART_IT_RXNE); //ֻUSART_ReceiveDataҲ
	   recContent =  USART_ReceiveData(USART1);
	   
	   if(recContent == '$')
	   {
		arry_length=0;
	   }
		arry[arry_length++] = recContent;
		
		if( arry[0] == '$' &&   arry[4] == 'M' && arry[5] == 'C' )
		{
			if(recContent == '\n')
			{
				memset(gps.Frame_Buffer,0,BUFF_MAX);
				memcpy(gps.Frame_Buffer,arry,arry_length);\
				gps.buff_flag = 1;
				memset(arry,0,arry_length);
				arry_length = 0;
			}
		}
		if(arry_length >=256 )
		{
			arry_length = 256;
		}
	}
    // жϵʱ˵ûˣռ
    else if(USART_GetFlagStatus(USART1, USART_FLAG_IDLE) != RESET)
    {
			USART1->DR;                 //λ
    }
} 






int fputc(int ch,FILE *f)
{
	
	USART_SendData(USART2,(uint8_t) ch);
	while(USART_GetFlagStatus(USART2,USART_FLAG_TXE)==RESET);
	return (ch);
}

/* USART1ַͺ*/
void USART1_SEND(u8* data,u16 length)
{
	u16 i;
  for( i=0;i<length;i++)
	{
	USART_SendData(USART1,data[i]);
	while(USART_GetFlagStatus(USART1,USART_FLAG_TXE)==RESET);
	}
}

/* USART2ַͺ*/
void USART2_SEND(u8 * data,u16 length)
{
	u16 i;
  for( i=0;i<length;i++)
	{
	USART_SendData(USART2,data[i]);
	while(USART_GetFlagStatus(USART2,USART_FLAG_TXE)==RESET);
	}
}