//**** 声明 ********************************************************************
/*******************************************************************************
 * 下面来自互联开源程序，由深圳市大夏龙雀科技有限公司收集
 * 方便用户参考学习，本公司不提供任何技术支持
 * 程序仅供测试参考，不能应用在实际工程中，不一定能通过编译
 * 公司网站 http://www.szdx-smart.com/
 * 淘宝网址 https://shop184598174.taobao.com/?spm=a1z10.5-c-s.w12096189-21564973333.3.547b1176WCCDxR&scene=taobao_shop
*******************************************************************************/
/********************************************************************
* 文件名  ：  单片机通过4G模块获取GPS定位信息
* 描述    :  该文件实现通过4G模块获取GPS定位信息
***********************************************************************/
/*
 Name: GPS   
 Created: 2024/8/21 
 Author: WAM
*/
#include "main.h"
#include <stdlib.h>

extern struct GPS  gps;
void Data_Transfor(void);
int main()
{
	NVIC_PriorityGroupConfig(NVIC_PriorityGroup_2);  
	
	USART2_Config(9600);
	USART1_Config(9600);
	char * point =NULL;
	char * nextpoint =NULL;
	uint8_t tempvar=0;
	delay_ms(3000);
	USART1_SEND("AT+MGPSC=1\r\n",strlen("AT+MGPSC=1\r\n"));//开启GPS定位
	while(1)
	{
	if(gps.buff_flag == 1)
	{
		if(strstr(gps.Frame_Buffer,"GNRMC")!=NULL)
		{
			for(tempvar=0;tempvar < 10;tempvar++)
			{
			if(tempvar==0)
			{
				if((point = strstr(gps.Frame_Buffer,","))==NULL)
				{
					printf("Prase errpr\r\n");
				}
			}
			else
			{
				point++;
				if((nextpoint = strstr(point,","))!=NULL)
				{
				
				switch(tempvar)
				{
					case 1://时间
					memcpy(gps.UTCTime,point,nextpoint-point);
					break;
					case 2://
					memcpy(gps.GPS_Status,point,nextpoint-point);
					break;
					case 3://
					memcpy(gps.GPS_lat,point,nextpoint-point);
					break;
					case 4://
					memcpy(gps.GPS_ulat,point,nextpoint-point);
					break;
					case 5://
					memcpy(gps.GPS_lon,point,nextpoint-point);
					break;
					case 6://
					memcpy(gps.GPS_ulon,point,nextpoint-point);
					break;
					case 7://
					memcpy(gps.GPS_spd,point,nextpoint-point);
					break;
					case 8://
					memcpy(gps.GPS_cog,point,nextpoint-point);
					break;
					case 9://
					memcpy(gps.GPS_date,point,nextpoint-point);
					break;
				}
				point = nextpoint;	
				}
				else
				{
					printf("Prase errpr\r\n");
				}
			}
			}
			//解析数据
			Data_Transfor();
		}
		
			gps.buff_flag = 0;
			gps.buff_length=0;
			memset(gps.Frame_Buffer,0,sizeof(gps)/sizeof(gps.buff_flag));
	
		
		
	}	
	}
	
	
	
}

void Data_Transfor(void)
{
	float latitude = 0;//存储维度消息
	float longitude = 0;//存储维度消息
	float time = 0;//存储时间消息
	uint16_t temp1=0;//临时变量1 存储整数
	uint16_t temp2=0;//临时变量2 存储整数
	uint16_t temp3=0;//临时变量3 存储整数
	latitude = strtod(gps.GPS_lat,NULL);
	longitude = strtod(gps.GPS_lon,NULL);
	time = strtod(gps.UTCTime,NULL);
	if( latitude - 10000.0 >= 0 )
	{
		//前三位单独拿出来组成一个数
		temp1 =   (((u16)latitude/10000)%10)*100 + (((u16)latitude/1000)%10)*10+ (((u16)latitude/100)%10);
		latitude = latitude - (float)temp1*100;
		latitude =  (float)temp1 + latitude/60;
		printf("latitude:%.3f\r\n",latitude);
	}
	else
	{
		temp1 =  (((u16)latitude/1000)%10)*10+ (((u16)latitude/100)%10);
		latitude = latitude - (float)temp1*100;
		latitude =  (float)temp1 + latitude/60;
		printf("latitude:%.3f\r\n",latitude);
	}
	if( longitude - 10000.0 >= 0 )
	{
		//前三位单独拿出来组成一个数
		temp1 =   (((u16)longitude/10000)%10)*100 + (((u16)longitude/1000)%10)*10+ (((u16)longitude/100)%10);
		longitude = longitude - (float)temp1*100;
		longitude =  (float)temp1 + longitude/60;
		printf("latitude:%.3f\r\n",longitude);
	}
	else
	{
		temp1 =  (((u16)longitude/1000)%10)*10+ (((u16)longitude/100)%10);
		longitude = longitude - (float)temp1*100;
		longitude =  (float)temp1 + longitude/60;
		printf("latitude:%.3f\r\n",longitude);
	}
	 printf("time %c%c:%c%c:%c%c\r\n",gps.UTCTime[0],gps.UTCTime[1],gps.UTCTime[2],gps.UTCTime[3],gps.UTCTime[4],gps.UTCTime[5]);
	 printf("date %c%c:%c%c:%c%c\r\n",gps.GPS_date[4],gps.GPS_date[5],gps.GPS_date[2],gps.GPS_date[3],gps.GPS_date[0],gps.GPS_date[1]);

}